/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.golem;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.xkmc.l2library.util.nbt.ItemCompoundTag;
import dev.xkmc.l2library.util.nbt.ItemListTag;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.golem.GolemBEWLR;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.item.golem.NBTAnalytic;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class GolemHolder<T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>>
extends Item {
    public static final String KEY_MATERIAL = "golem_materials";
    public static final String KEY_UPGRADES = "golem_upgrades";
    public static final String KEY_ENTITY = "golem_entity";
    public static final String KEY_DISPLAY = "golem_display";
    public static final String KEY_ICON = "golem_icon";
    public static final String KEY_CONFIG = "golem_config";
    public static final String KEY_PART = "part";
    public static final String KEY_MAT = "material";
    private final RegistryEntry<GolemType<T, P>> type;

    public static ArrayList<GolemMaterial> getMaterial(ItemStack stack) {
        ArrayList<GolemMaterial> ans = new ArrayList<GolemMaterial>();
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(KEY_MATERIAL, 9)) {
            ListTag list = tag.m_128437_(KEY_MATERIAL, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag elem = list.m_128728_(i);
                GolemPart part = (GolemPart)ForgeRegistries.ITEMS.getValue(new ResourceLocation(elem.m_128461_(KEY_PART)));
                ResourceLocation mat = new ResourceLocation(elem.m_128461_(KEY_MAT));
                if (part == null) continue;
                ans.add(part.parseMaterial(mat));
            }
        }
        return ans;
    }

    public static ArrayList<UpgradeItem> getUpgrades(ItemStack stack) {
        ArrayList<UpgradeItem> ans = new ArrayList<UpgradeItem>();
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(KEY_UPGRADES, 9)) {
            ListTag list = tag.m_128437_(KEY_UPGRADES, 8);
            for (int i = 0; i < list.size(); ++i) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(list.m_128778_(i)));
                if (!(item instanceof UpgradeItem)) continue;
                UpgradeItem up = (UpgradeItem)item;
                ans.add(up);
            }
        }
        return ans;
    }

    public static Optional<Pair<UUID, Integer>> getGolemConfig(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(KEY_CONFIG);
        if (tag != null) {
            return Optional.of(Pair.of((Object)tag.m_128342_("id"), (Object)tag.m_128451_("color")));
        }
        return Optional.empty();
    }

    public static void setGolemConfig(ItemStack stack, UUID id, int color) {
        CompoundTag tag = ItemCompoundTag.of((ItemStack)stack).getSubTag(KEY_CONFIG).getOrCreate();
        tag.m_128362_("id", id);
        tag.m_128405_("color", color);
    }

    public static void addMaterial(ItemStack stack, GolemPart<?, ?> item, ResourceLocation material) {
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey(item);
        assert (rl != null);
        ItemCompoundTag tag = ItemCompoundTag.of((ItemStack)stack);
        CompoundTag elem = tag.getSubList(KEY_MATERIAL, 10).addCompound().getOrCreate();
        elem.m_128365_(KEY_PART, (Tag)StringTag.m_129297_((String)rl.toString()));
        elem.m_128365_(KEY_MAT, (Tag)StringTag.m_129297_((String)material.toString()));
    }

    public static ItemStack addUpgrade(ItemStack stack, UpgradeItem item) {
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)item);
        assert (rl != null);
        ItemCompoundTag tag = ItemCompoundTag.of((ItemStack)stack);
        tag.getSubList(KEY_UPGRADES, 8).getOrCreate().add((Object)StringTag.m_129297_((String)rl.toString()));
        return stack;
    }

    public static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> ItemStack setEntity(T entity) {
        GolemHolder holder = GolemType.getGolemHolder(entity.m_6095_());
        ItemStack stack = new ItemStack(holder);
        ItemCompoundTag tag = ItemCompoundTag.of((ItemStack)stack);
        GolemConfigEntry config = entity.getConfigEntry(null);
        if (config != null) {
            GolemHolder.setGolemConfig(stack, config.getID(), config.getColor());
        }
        ItemListTag matlist = tag.getSubList(KEY_MATERIAL, 10);
        for (GolemMaterial golemMaterial : entity.getMaterials()) {
            ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)golemMaterial.part());
            assert (rl != null);
            CompoundTag elem = matlist.addCompound().getOrCreate();
            elem.m_128365_(KEY_PART, (Tag)StringTag.m_129297_((String)rl.toString()));
            elem.m_128365_(KEY_MAT, (Tag)StringTag.m_129297_((String)golemMaterial.id().toString()));
        }
        ListTag uplist = tag.getSubList(KEY_UPGRADES, 8).getOrCreate();
        for (Item item : entity.getUpgrades()) {
            ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)item);
            assert (rl != null);
            uplist.add((Object)StringTag.m_129297_((String)rl.toString()));
        }
        entity.m_20223_(tag.getSubTag(KEY_ENTITY).getOrCreate());
        Component component = entity.m_7770_();
        if (component != null) {
            stack.m_41714_(component);
        }
        return stack;
    }

    public static float getHealth(ItemStack stack) {
        return Optional.ofNullable(stack.m_41783_()).filter(e -> e.m_128441_(KEY_ENTITY)).map(e -> e.m_128469_(KEY_ENTITY)).map(e -> Float.valueOf(e.m_128457_("Health"))).orElse(Float.valueOf(-1.0f)).floatValue();
    }

    public static float getMaxHealth(ItemStack stack) {
        return Optional.ofNullable(stack.m_41783_()).filter(e -> e.m_128441_(KEY_ENTITY)).map(e -> e.m_128469_(KEY_ENTITY)).flatMap(e -> e.m_128437_("Attributes", 10).stream().map(t -> (CompoundTag)t).filter(t -> t.m_128461_("Name").equals("minecraft:generic.max_health")).findAny()).map(e -> Float.valueOf(e.m_128457_("Base"))).orElse(Float.valueOf(-1.0f)).floatValue();
    }

    public static void setHealth(ItemStack result, float health) {
        result.m_41784_().m_128469_(KEY_ENTITY).m_128350_("Health", health);
    }

    public static ItemStack toEntityIcon(ItemStack golem, ItemStack ... equipments) {
        ItemListTag list = ItemCompoundTag.of((ItemStack)golem).getSubList(KEY_ICON, 10);
        for (ItemStack e : equipments) {
            list.addCompound().setTag(e.serializeNBT());
        }
        return golem;
    }

    public GolemHolder(Item.Properties props, RegistryEntry<GolemType<T, P>> type) {
        super(props.m_41487_(1));
        this.type = type;
        GolemType.GOLEM_TYPE_TO_ITEM.put(type.getId(), this);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        CompoundTag root = stack.m_41783_();
        if (root == null) {
            return;
        }
        if (root.m_128441_(KEY_ENTITY) && entity.f_19797_ % 20 == 0) {
            float health = GolemHolder.getHealth(stack);
            float maxHealth = GolemHolder.getMaxHealth(stack);
            if (health > 0.0f && health < maxHealth) {
                ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
                ArrayList<UpgradeItem> upgrades = GolemHolder.getUpgrades(stack);
                Map<Attribute, Pair<GolemStatType, Double>> attr = GolemMaterial.collectAttributes(mats, upgrades);
                HashMap<GolemModifier, Integer> modifiers = GolemMaterial.collectModifiers(mats, upgrades);
                double heal = (Double)attr.getOrDefault(GolemTypes.GOLEM_REGEN.get(), (Pair<GolemStatType, Double>)Pair.of((Object)((Object)((GolemStatType)((Object)GolemTypes.STAT_REGEN.get()))), (Object)0.0)).getSecond();
                GolemModifier.HealingContext ctx = new GolemModifier.HealingContext(health, maxHealth, entity);
                for (Map.Entry<GolemModifier, Integer> entry : modifiers.entrySet()) {
                    heal = entry.getKey().onInventoryHealTick(heal, ctx, entry.getValue());
                }
                if (heal > 0.0) {
                    GolemHolder.setHealth(stack, Math.min(maxHealth, (float)heal + health));
                }
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Screen.m_96639_()) {
            NBTAnalytic.analyze(stack, list);
            return;
        }
        if (!Screen.m_96638_()) {
            float max = GolemHolder.getMaxHealth(stack);
            if (max >= 0.0f) {
                float health = GolemHolder.getHealth(stack);
                float f = Mth.m_14036_((float)(health / max), (float)0.0f, (float)1.0f);
                int color = Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
                MutableComponent hc = Component.m_237113_((String)("" + Math.round(health))).m_6270_(Style.f_131099_.m_178520_(color));
                list.add((Component)MGLangData.HEALTH.get(hc, Math.round(max)).m_130940_(health <= 0.0f ? ChatFormatting.RED : ChatFormatting.AQUA));
            }
            Optional<Pair<UUID, Integer>> config = GolemHolder.getGolemConfig(stack);
            if (level == null || config.isEmpty()) {
                list.add((Component)MGLangData.NO_CONFIG.get(new Object[0]));
            } else {
                UUID id = (UUID)config.get().getFirst();
                Integer color = (Integer)config.get().getSecond();
                GolemConfigEntry entry = GolemConfigStorage.get(level).getOrCreateStorage(id, color, (Component)MGLangData.LOADING.get(new Object[0]));
                entry.clientTick(level, false);
                list.add(entry.getDisplayName());
            }
            ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
            ArrayList<UpgradeItem> upgrades = GolemHolder.getUpgrades(stack);
            IGolemPart[] parts = this.getEntityType().values();
            if (mats.size() == parts.length) {
                for (int i = 0; i < parts.length; ++i) {
                    list.add((Component)parts[i].getDesc(mats.get(i).getDesc()));
                }
            }
            list.add((Component)MGLangData.SLOT.get(this.getRemaining(mats, upgrades)).m_130940_(ChatFormatting.AQUA));
            HashMap<GolemModifier, Integer> modifiers = GolemMaterial.collectModifiers(mats, upgrades);
            if (modifiers.size() > 8) {
                list.add((Component)MGLangData.UPGRADE_COUNT.get(modifiers.size(), upgrades.size()));
            } else {
                modifiers.forEach((k, v) -> list.add(k.getTooltip((int)v)));
            }
            GolemMaterial.collectAttributes(mats, upgrades).forEach((k, v) -> {
                if (Math.abs((Double)v.getSecond()) > 0.001) {
                    list.add((Component)((GolemStatType)((Object)((Object)v.getFirst()))).getTotalTooltip((Double)v.getSecond()));
                }
            });
            list.add((Component)MGLangData.SHIFT.get(new Object[0]));
        } else {
            ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
            ArrayList<UpgradeItem> upgrades = GolemHolder.getUpgrades(stack);
            HashMap<GolemModifier, Integer> map = GolemMaterial.collectModifiers(mats, upgrades);
            int size = map.size();
            int index = 0;
            for (Map.Entry<GolemModifier, Integer> entry : map.entrySet()) {
                GolemModifier k2 = entry.getKey();
                Integer v2 = entry.getValue();
                list.add(k2.getTooltip(v2));
                if (size > 12 || size > 4 && (level == null || !level.m_5776_() || level.m_46467_() / 30L % (long)size != (long)(++index - 1))) continue;
                list.addAll(k2.getDetail(v2));
            }
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Vec3 pos;
        CompoundTag root = stack.m_41783_();
        if (root == null) {
            return InteractionResult.PASS;
        }
        Level level = player.m_9236_();
        if (this.summon(stack, level, pos = target.m_20182_(), player, e -> e.checkRide(target))) {
            if (!level.m_5776_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public boolean canGrindstoneRepair(ItemStack stack) {
        return true;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        CompoundTag root = stack.m_41783_();
        if (root == null) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockstate = level.m_8055_(blockpos);
        BlockPos spawnPos = blockstate.m_60812_((BlockGetter)level, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        Vec3 pos = new Vec3((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 0.05, (double)spawnPos.m_123343_() + 0.5);
        if (this.summon(stack, level, pos, context.m_43723_(), null)) {
            if (context.m_43723_() != null && !context.m_43725_().m_5776_()) {
                context.m_43723_().m_21008_(context.m_43724_(), ItemStack.f_41583_);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public boolean summon(ItemStack stack, Level level, Vec3 pos, @Nullable Player player, @Nullable Consumer<AbstractGolemEntity<?, ?>> callback) {
        CompoundTag root = stack.m_41783_();
        if (root == null) {
            return false;
        }
        if (root.m_128441_(KEY_ENTITY) && GolemHolder.getMaxHealth(stack) >= 0.0f) {
            if (GolemHolder.getHealth(stack) <= 0.0f) {
                return false;
            }
            if (!level.m_5776_()) {
                Object golem = ((GolemType)((Object)this.type.get())).create((ServerLevel)level, root.m_128469_(KEY_ENTITY));
                UUID id = player == null ? null : player.m_20148_();
                ((AbstractGolemEntity)((Object)golem)).updateAttributes(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), id);
                golem.m_20219_(pos);
                GolemHolder.getGolemConfig(stack).ifPresent(e -> golem.setConfigCard((UUID)e.getFirst(), (Integer)e.getSecond()));
                if (stack.m_41788_()) {
                    golem.m_6593_(stack.m_41786_());
                }
                if (!((AbstractGolemEntity)((Object)golem)).initMode(player)) {
                    return false;
                }
                level.m_7967_(golem);
                stack.m_41749_(KEY_ENTITY);
                stack.m_41774_(1);
                if (callback != null) {
                    callback.accept((AbstractGolemEntity<?, ?>)((Object)golem));
                }
            }
            return true;
        }
        if (root.m_128441_(KEY_MATERIAL)) {
            if (!level.m_5776_()) {
                Object golem = ((GolemType)((Object)this.type.get())).create(level);
                golem.m_20219_(pos);
                UUID id = player == null ? null : player.m_20148_();
                ((AbstractGolemEntity)((Object)golem)).onCreate(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), id);
                GolemHolder.getGolemConfig(stack).ifPresent(e -> golem.setConfigCard((UUID)e.getFirst(), (Integer)e.getSecond()));
                if (stack.m_41788_()) {
                    golem.m_6593_(stack.m_41786_());
                }
                if (!((AbstractGolemEntity)((Object)golem)).initMode(player)) {
                    return false;
                }
                level.m_7967_(golem);
                if (player == null || !player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (callback != null) {
                    callback.accept((AbstractGolemEntity<?, ?>)((Object)golem));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public T createDummy(ItemStack stack, Level level) {
        Object golem;
        CompoundTag root = stack.m_41783_();
        if (root == null) {
            return null;
        }
        if (root.m_128441_(KEY_ENTITY)) {
            golem = ((GolemType)((Object)this.type.get())).create((ServerLevel)level, root.m_128469_(KEY_ENTITY));
            ((AbstractGolemEntity)((Object)golem)).updateAttributes(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), null);
        } else if (root.m_128441_(KEY_MATERIAL)) {
            golem = ((GolemType)((Object)this.type.get())).create(level);
            ((AbstractGolemEntity)((Object)golem)).onCreate(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), null);
        } else {
            return null;
        }
        GolemHolder.getGolemConfig(stack).ifPresent(e -> golem.setConfigCard((UUID)e.getFirst(), (Integer)e.getSecond()));
        if (stack.m_41788_()) {
            golem.m_6593_(stack.m_41786_());
        }
        return golem;
    }

    public boolean m_142522_(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(KEY_DISPLAY)) {
            return true;
        }
        return GolemHolder.getMaxHealth(stack) >= 0.0f;
    }

    public int m_142159_(ItemStack stack) {
        float f;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(KEY_DISPLAY)) {
            f = stack.m_41783_().m_128457_(KEY_DISPLAY);
        } else {
            float health = GolemHolder.getHealth(stack);
            float maxHealth = GolemHolder.getMaxHealth(stack);
            f = Mth.m_14036_((float)(health / maxHealth), (float)0.0f, (float)1.0f);
        }
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(KEY_DISPLAY)) {
            float f = stack.m_41783_().m_128457_(KEY_DISPLAY);
            return Math.round(f * 13.0f);
        }
        return Math.round(Mth.m_14036_((float)(GolemHolder.getHealth(stack) / GolemHolder.getMaxHealth(stack)), (float)0.0f, (float)1.0f) * 13.0f);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(GolemBEWLR.EXTENSIONS);
    }

    public GolemType<T, P> getEntityType() {
        return (GolemType)((Object)this.type.get());
    }

    public void fillItemCategory(CreativeModeTabModifier tab) {
        for (ResourceLocation rl : GolemMaterialConfig.get().getAllMaterials()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            for (IGolemPart part : this.getEntityType().values()) {
                GolemHolder.addMaterial(stack, part.toItem(), rl);
            }
            tab.m_246342_(stack);
        }
    }

    public ItemStack withUniformMaterial(ResourceLocation rl) {
        ItemStack stack = new ItemStack((ItemLike)this);
        for (IGolemPart part : this.getEntityType().values()) {
            GolemHolder.addMaterial(stack, part.toItem(), rl);
        }
        return stack;
    }

    public int getRemaining(ArrayList<GolemMaterial> mats, ArrayList<UpgradeItem> upgrades) {
        int base = this.getEntityType().values().length;
        if (this.type.get() == GolemTypes.TYPE_GOLEM.get()) {
            base = (Integer)MGConfig.COMMON.largeGolemSlot.get();
        } else if (this.type.get() == GolemTypes.TYPE_HUMANOID.get()) {
            base = (Integer)MGConfig.COMMON.humanoidGolemSlot.get();
        } else if (this.type.get() == GolemTypes.TYPE_DOG.get()) {
            base = (Integer)MGConfig.COMMON.dogGolemSlot.get();
        }
        base -= upgrades.size();
        HashMap<GolemModifier, Integer> modifiers = GolemMaterial.collectModifiers(mats, upgrades);
        for (Map.Entry<GolemModifier, Integer> ent : modifiers.entrySet()) {
            base += ent.getKey().addSlot(upgrades, ent.getValue());
        }
        return base;
    }

    public void onDestroyed(ItemEntity entity, DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            for (UpgradeItem e : GolemHolder.getUpgrades(entity.m_32055_())) {
                entity.m_9236_().m_7967_((Entity)new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), e.m_7968_()));
            }
        }
    }
}

